
close all

%%
% Counterfactual Time Series Data
CFTSGer = readtable('../Data/CounterfactualTimeSeriesGermany.csv');
CFTSUsa = readtable('../Data/CounterfactualTimeSeriesUSA.csv');

%CFTSGer.c_lnJTS1000HIL = str2double(CFTSGer.c_lnJTS1000HIL);
startDate = datenum('01-01-1948');
endDate = datenum('12-01-2018');
tGrid = linspace(startDate,endDate,284);
CFTSGer.date = tGrid';
CFTSGer.qrt = quarter(CFTSGer.date);
CFTSGer.year = year(CFTSGer.date);

%CFTSUsa.c_lnJTS1000HIL = str2double(CFTSUsa.c_lnJTS1000HIL);
startDate = datenum('01-01-1948');
endDate = datenum('12-01-2018');
tGrid = linspace(startDate,endDate,284);
CFTSUsa.date = tGrid';

xLabel = 'Year';
yLabel = 'Deviation from Trend (\%)';

%% *** HWI Job Opening Rates***
figNum = 1;

figure(figNum)
plot(CFTSGer.date,100*CFTSGer.c_lnhwi,ls.lineSpec2{:})
hold on
plot(CFTSGer.date,100*CFTSGer.cyc_lncf_hwi,ls.lineSpec44{:})
plot(CFTSUsa.date,100*CFTSUsa.cyc_lncf_hwi,ls.lineSpec4{:})
hold off

tick = datenum(1952:5:2017,1,1);
set(gca, 'xtick', tick);
datetick('x', 'yy', 'keepticks');
legend('Job Openings (HWI)','Counterfactual - $\rho=0.56$','Counterfactual - $\rho=0.927$')
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel);
ylim([-80 40])
export_fig(figure(figNum),[ls.graphPath 'CF_HWI_JOR'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** JOLTS Jop Openings ***
% CFTSGer = rmmissing(CFTSGer);
% CFTSUsa = rmmissing(CFTSUsa);
figure(figNum)
plot(CFTSGer.date,100*CFTSGer.c_lnJTS1000JOL,ls.lineSpec2{:})
hold on
plot(CFTSGer.date,100*CFTSGer.cyc_lncf_vac,ls.lineSpec4{:})
plot(CFTSUsa.date,100*CFTSUsa.cyc_lncf_vac,ls.lineSpec44{:})
hold off
tick = datenum(2001:1:2017,1,1);
set(gca, 'xtick', tick);
datetick('x', 'yy', 'keepticks');
legend('Job Openings (JOLTS)','Counterfactual - $\rho=0.56$','Counterfactual - $\rho=0.927$')
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel);
ylim([-80 40])

export_fig(figure(figNum),[ls.graphPath 'CF_JOLTS_JOR'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** JOLTS Hires ***
figure(figNum)
plot(CFTSGer.date,100*CFTSGer.c_lnJTS1000HIL,ls.lineSpec1{:})
hold on
plot(CFTSGer.date,100*CFTSGer.cyc_lncf_hil,ls.lineSpec4{:})
plot(CFTSUsa.date,100*CFTSUsa.cyc_lncf_hil,ls.lineSpec44{:})

hold off
tick = datenum(2001:1:2017,1,1);
set(gca, 'xtick', tick);
datetick('x', 'yy', 'keepticks');
legend('Hires (JOLTS)','Counterfactual - $\rho=0.56$','Counterfactual - $\rho=0.927$')
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
%xlabel(xLabel);
ylabel(yLabel);
ylim([-30 30])

export_fig(figure(figNum),[ls.graphPath 'CF_JOLTS_HIL'],'-pdf','-transparent');

figNum = figNum + 1;






